/* file: m2a.c		G. Moody	 9 June 1983
			Last revised:   26 April 2001

-------------------------------------------------------------------------------
m2a: Convert MIT format annotation files to AHA DB distribution tape format
Copyright (C) 2001 George B. Moody

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, see <http://www.gnu.org/licenses/>.

You may contact the author by e-mail (wfdb@physionet.org) or postal mail
(MIT Room E25-505A, Cambridge, MA 02139 USA).  For updates to this software,
please visit PhysioNet (http://www.physionet.org/).
_______________________________________________________________________________

The files generated by this program are in the format formerly used for
distribution of the AHA and MIT-BIH databases on half-inch 9-track digital
tape.  This program is provided as a convenience for those who may have
software that requires files in AHA tape format as input.  It does *not*
generate files in the format currently used for distribution of the AHA
database on floppy disk;  program `a2m.c' can perform the reverse conversion,
however.
*/

#include <stdio.h>
#ifndef __STDC__
#ifndef MSDOS
extern void exit();
#endif
#endif

#include <wfdb/wfdb.h>

char *pname;

main(argc, argv)
int argc;
char *argv[];
{
    char *ianame = NULL, *oaname = NULL, *record = NULL, *shift = NULL;
    char *prog_name();
    int i;
    WFDB_Anninfo afarray[2];
    WFDB_Annotation annot;
    void help();

    pname = prog_name(argv[0]);
    for (i = 1; i < argc; i++) {
	if (*argv[i] == '-') switch (*(argv[i]+1)) {
	  case 'a':	/* annotator names follow */
	    if (++i >= argc-1) {
		(void)fprintf(stderr,
		       "%s: input and output annotator names must follow -a\n",
			      pname);
		exit(1);
	    }
	    ianame = argv[i++];
	    oaname = argv[i];
	    break;
	  case 'h':	/* help requested */
	    help();
	    exit(1);
	    break;
	  case 'r':	/* record name follows */
	    if (++i >= argc) {
		(void)fprintf(stderr,
			      "%s: record name must follow -r\n", pname);
		exit(1);
	    }
	    record = argv[i];
	    break;
	  case 's':	/* shift follows */
	    if (++i >= argc) {
		(void)fprintf(stderr,
			      "%s: time shift must follow -s\n", pname);
		exit(1);
	    }
	    shift = argv[i];
	    break;
	    
	  default:
	    (void)fprintf(stderr, "%s: unrecognized option %s\n", pname,
			  argv[i]);
	    exit(1);
	}
	else {
	    (void)fprintf(stderr, "%s: unrecognized argument %s\n", pname,
			  argv[i]);
	    exit(1);
	}
    }
    if (ianame == NULL || oaname == NULL || record == NULL) {
	help();
	exit(1);
    }

    afarray[0].name = ianame; afarray[0].stat = WFDB_READ;
    afarray[1].name = oaname; afarray[1].stat = WFDB_AHA_WRITE;
    if (annopen(record, afarray, 2) < 0)	/* open files */
	exit(2);
    if (shift == NULL)
	while (getann(0, &annot) >= 0)	/* copy annotations to end of data */
	    (void)putann(0, &annot);
    else {
	long dt;
	double mssi;	/* milliseconds per sample interval */

	if (sampfreq(record) <= 0.) (void)setsampfreq(WFDB_DEFFREQ);
	mssi = 1000./strtim("1");
	dt = strtim(shift);
	while (getann(0, &annot) >= 0)
	    if (annot.time >= dt) {
		annot.time = (annot.time - dt)*mssi;
		(void)putann(0, &annot);
	    }
    }

    wfdbquit();
    exit(0);	/*NOTREACHED*/
}

char *prog_name(s)
char *s;
{
    char *p = s + strlen(s);

#ifdef MSDOS
    while (p >= s && *p != '\\' && *p != ':') {
	if (*p == '.')
	    *p = '\0';		/* strip off extension */
	if ('A' <= *p && *p <= 'Z')
	    *p += 'a' - 'A';	/* convert to lower case */
	p--;
    }
#else
    while (p >= s && *p != '/')
	p--;
#endif
    return (p+1);
}

static char *help_strings[] = {
    "usage: %s -r RECORD -a MIT-ANNOTATOR AHA-ANNOTATOR [ OPTIONS ... ]\n",
    "where RECORD is the record name, MIT-ANNOTATOR is the annotator name",
    "for the input annotation file, AHA-ANNOTATOR is the annotator name",
    "for the output (AHA format) annotation file, and OPTIONS may include:",
    " -h        print this usage summary",
    " -s TIME   shift annotation times backwards by the specified TIME,",
    "            and convert them to milliseconds",
    NULL
};

void help()
{
    int i;

    (void)fprintf(stderr, help_strings[0], pname);
    for (i = 1; help_strings[i] != NULL; i++)
	(void)fprintf(stderr, "%s\n", help_strings[i]);
}
