function BuildInterfaceSpectral(ECGCallb, SICallb, AltSCallb)
% BuildInterfaceMMA.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Contructs interface to view SM analysis
% subplot 1: ECG and the superimposed landmarks
% subplot 2: two successive beats and template superimposed on the same graph
% subplot 3: TWA series for an analysis window of 128 beats, for the
%            selected point in subplot 2 (S-Tend)
% subplot 4: Power Spectral Density of the selected point in subplot 2
%            (S-Tend) across all 128 points and lomb periodogram if
%            necessary
% subplot 5: Power Spectral Density averaged over S-Tend segment
% See LeadBtnCallback.m, BtnDownCallback, DoTWASpectral.m   for more information


    global graph;

    f = figure('Units','normalized','Position',[0.1 0.3 0.8 0.65]);
        
    graph(1) = subplot('Position',[0.05 0.5 0.91 0.4]);
    graph(2) = subplot('Position',[0.05 0.05 0.19 0.4]);
    graph(3) = subplot('Position',[0.29 0.05 0.19 0.4]);
    graph(4) = subplot('Position',[0.53 0.05 0.19 0.4]);
    graph(5) = subplot('Position',[0.77 0.05 0.19 0.4]);

    set(f, 'WindowButtonDownFcn', {@BtnDownCallback, graph, ECGCallb, SICallb, AltSCallb})
    
    global stext;
    for i = 1:3
        stext(i) = uicontrol('Style', 'text', 'Units', 'normalized', 'Position',[0.05 (1 - 0.033 * i) 0.9 0.03], ...
            'String','', 'HorizontalAlignment', 'left');
    end;
    leadbtn = uicontrol('Style', 'pushbutton', 'Units', 'normalized', 'Position',[0.91 0.91 0.05 0.08], ...
        'String','lead is 1', 'Callback', 'LeadBtnCallback');
    global record recordbtn
    recordbtn = uicontrol('Style', 'pushbutton', 'Units', 'normalized', 'Position',[0.70 0.91 0.2 0.08], ...
        'String',record, 'Callback', 'DoTWASpectral');

    set(gcf, 'Toolbar', 'figure');
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function BtnDownCallback(obj, eventdata, graph, ECGCallb, SICallb, AltSCallb)

    if (gca == graph(1))
        feval(ECGCallb);
    elseif (gca == graph(2))
        feval(SICallb);
    elseif (gca == graph(3))
        feval(AltSCallb);
    end;
	
return;
