function DrawAvg
% DrawAvg.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the MMA averages

global TWARes graph lead CurResIndex Align

subplot(graph(2)); cla; hold on;

if (~TWARes.successfull || ~TWARes.res(CurResIndex).validleads(lead))
    return;
end;


colors = {'b', 'g'};
for i = 1:2
    qsa = TWARes.res(CurResIndex).Avg(i, lead).qs_avg; 
    sta = TWARes.res(CurResIndex).Avg(i, lead).st_avg; 

    h(i) = plot(qsa, colors{i});
    ind = length(qsa) + 10;
    plot(ind:(ind + length(sta) - 1), sta, colors{i});
end;

x = TWARes.res(CurResIndex).VAltPt(lead) + ind - 1;
h(3) = plot([x x], get(gca, 'YLim'), 'm');

% points after this one are taken into account
% x = Align.q2f(CurResIndex) + Align.f2s(CurResIndex);
% plot([x x], get(gca, 'YLim'), 'r');

legend(h, 'even beat avg', 'odd beat avg', 'point of max alternans', 2)

hold off

return;
