function DrawSelections
% DrawSelections.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws current beat (the one before the cursor in the ecg window) vs
% MMA average on previous and current interval

global TWARes graph lead CurResIndex Align ecg

hg = [graph(4) graph(5)];

for i = 1:2
    subplot(hg(i));
    cla;
    hold on;
    
    if (CurResIndex == 1)
        prev_qs_avg = Align.qs_templ(:, lead);
        prev_st_avg = Align.st_templ(:, lead);
    else
        prev_qs_avg = TWARes.res(CurResIndex - 1).Avg(i, lead).qs_avg;
        prev_st_avg = TWARes.res(CurResIndex - 1).Avg(i, lead).st_avg;
    end;
    
    ist = length(prev_qs_avg) + 10;
    indices_st = ist:(ist + length(prev_st_avg) - 1);
    
    % ecg used to update average
    global CurQRS
    ind = CurQRS;
    ev_odd = mod(ind, 2) + 1;
    h(1) = 0;
    if (ev_odd == i)       
%     for ind = TWARes.res(CurResIndex).StartQRSInd:TWARes.res(CurResIndex).EndQRSInd
       h(1) = plot(ecg(Align.fidQRS(ind) - Align.q2f : Align.fidQRS(ind) + Align.f2s, lead) - Align.amp(ind, lead));
        plot(indices_st, ecg(Align.fid(ind) + Align.f2s : Align.fid(ind) + Align.f2s + Align.st, lead) - Align.amp(ind, lead));
%     end;
    end;
    
    % the interval started and finished with these
    h(2) = plot(prev_qs_avg, 'r');
    h(3) = plot(TWARes.res(CurResIndex).Avg(i, lead).qs_avg, 'g');
    plot(indices_st, prev_st_avg, 'r');
    plot(indices_st, TWARes.res(CurResIndex).Avg(i, lead).st_avg, 'g')
    
    % point of maximum alternans
    x = TWARes.res(CurResIndex).VAltPt(lead) + ist - 1;
    plot([x x], get(gca, 'YLim'), 'm');

    if (h(1))
        legend(h, 'curr beat', 'prev avg', 'curr avg', 2);
    else
        legend(h(2:3), 'prev avg', 'curr avg', 2);
    end;
end;
return;