function DrawText
% DrawText.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Displays TWA SM results as text

global stext TWARes Param lead Align

if (strcmp(Param.Metric, 'SM'))
    names = cellstr({'lomb', 'replace', 'differences'});

    s = '';
    ind = 1;
    for i = 1:length(names)
        if (~isfield(TWARes, names{i}) || isempty(TWARes.(names{i}).significant))
            continue;
        end;
        s = [names{i} ': '];
    
        noAlt = false;
        if (sum(TWARes.(names{i}).significant) > 0)
            significants = find(TWARes.(names{i}).significant);
            s = [s sprintf('Maximum alternans = %.2f mcV', max(TWARes.(names{i}).VAlt(significants)))];
        else
            noAlt = true;
            s = [s 'No significant alternans value in the file'];
        end;
    
        if (~Align.validleads(lead))
            s = [s sprintf('; lead %d is too noisy', lead)];            
        elseif (TWARes.(names{i}).VAlt(lead))
            s = [s sprintf('; Alternans in lead %d = %.2f mCV, ratio = %.2f', lead,  TWARes.(names{i}).VAlt(lead), TWARes.(names{i}).Ratio(lead))];
        else
            s = [s sprintf('; No positive alternans value in lead %d', lead)];            
        end;
        
        set(stext(ind), 'String', s);
        ind = ind + 1;
    end;        
else
    if (isempty(TWARes))
        return;
    end;

    global CurResIndex
    
    if (TWARes.successfull)
        s = sprintf('Maximum alternans = %.2f mcV; Alternans in lead %d, interval %d = %.2f mCV', max(max(TWARes.VAltTrend)), ...
            lead, CurResIndex, TWARes.res(CurResIndex).VAlt(lead));
    else
        s = 'The MMA analysis was unsuccessfull';
    end;
        
    set(stext, 'String', s);        
end;
return;
