function res = ReadSignalFromWFDB(varargin)
% ReadSignalFromWFDB.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Reads a record in WFDB format
% 
% varargin{1}: record name
% varargin{2}: (optional) number of samples to read
% varargin{3}: (optional) sample number of the first sample to read

global ecg s q qs stend freq tend


res = 0;

if ~nargin
    [fname, pathname] = uigetfile('*.*');
    if ~fname
        return;
    end;
    res = ReadSignalFromWFDB(strtok(fname, '.'));
    return;
end;


record = varargin{1};
hea = WFDB_isigopen(record);

for i = 1:length(hea)
    if ~hea(i).gain
        hea(i).gain = 200;
    end;
end;

% modified by Shamim to include NSAMP and TSTART
if (nargin > 3)
    NSAMP = varargin{3};
    TSTART = varargin{4};
else
    TSTART =0;
    NSAMP = hea(1).nsamp;  % assuming all channels have the same number of samples!
end

a = WFDB_Anninfo(1);
a.name = 'pu';
if nargin > 1
    a.name = varargin{2};
end;

WFDB_annopen(record, a);
WFDB_iannsettime(TSTART);
ann = WFDB_getann(0);

freq = WFDB_sampfreq(record);

ecg = WFDB_getvec(length(hea),NSAMP, TSTART); WFDB_wfdbquit;

ecg = (ecg - repmat([hea(:).baseline],NSAMP,1))./repmat([hea(:).gain]/1000,NSAMP,1); % convert to mCV

s=[]; tend=[]; q=[]; qs = []; stend = []; qlatest = -1;
% [q,q_amp,r,r_amp,s,s_amp,t,t_amp,tend,hr]  = QRSTdetect(ecg(:,1),freq); % only based on the first channel
% qs = s-q;
% stend = tend - s(1:length(tend));


%This loops extracts all s, q, qs length, end of T waves, and s to end of T length
%39 = Waveform onset, 40 = Waveform end, ... WFDB_anndesc(39)
% Modified by Shamim
i=1;
while(i<=length(ann) && ann(i).time<=TSTART+NSAMP)
    % Adjust the annotation time index
    ann(i).time = ann(i).time - TSTART;
    if (ann(i).num == 1 && ann(i).anntyp == 39 && ann(i).chan == 0)
        if ann(i).time <= size(ecg, 1)
            %q(length(q) + 1) = ann(i).time;
            qlatest = ann(i).time;
        end;
        % 40 = Waveform end
    elseif (ann(i).num == 1 && ann(i).anntyp == 40 && ann(i).chan == 0)
        if ann(i).time <= size(ecg, 1)
            if (qlatest ~= -1 && (isempty(s) || qlatest > s(length(s))))
                s(length(s) + 1) = ann(i).time;
                q(length(s)) = qlatest;
                qs(length(qs) + 1) = s(length(s)) - q(length(q));
            end;

            %see if valid st is availiable for previous s
            if (length(s) > 1)
                if (isempty(tend) || tend(length(tend)) < s(length(s) - 1))
                    stend(length(stend) + 1) = 0;
                else
                    stend(length(stend) + 1) = tend(length(tend)) - s(length(s) - 1);
                end;
            end;
        end;
    elseif (ann(i).num == 2 && ann(i).anntyp == 40 && ann(i).chan == 0)
        if ann(i).time <= size(ecg, 1)
            tend(length(tend) + 1) = ann(i).time;
        end;
    end;
    i=i+1;
end;
%ann = ann(1:i-1);
%see if valid st is availiable for the last s
if (length(tend) && tend(length(tend)) > s(length(s)))
    stend(length(stend) + 1) = tend(length(tend)) - s(length(s));
end;

res = 1;
return;