function BatchPU(varargin)
% BatchPU.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% accepts file with a list of records and runs ecgpuwave for all of them

    if ~nargin
        [fname, pathname] = uigetfile('*.*');
        if ~fname
            return;
        end;
        BatchPU(strcat(pathname, fname));
        return;
    end;    

   f = fopen(varargin{1});
   nextf = fgetl(f);

   while (nextf ~= -1)
        if (~exist(strcat(nextf, '.pu'),'file'))      
           ss = sprintf('ecgpuwave -r %s -a pu', nextf);
           disp(ss);
           system(ss);
       end
      
       nextf = fgetl(f);
   end;
    
fclose all;
return;
 