function DoTWASpectral(varargin)
% DoTWASpectral.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% This is the routine to run if you want analysis via Spectral Method
%
% Modify Param.MethodForEctopy in the code below to obtain results for a single method

    close all;
    clear all;
    
    global lead
    lead = 1;
    
    global Param
    Param.Metric = 'SM';    % spectral method
%     Param.MethodForEctopy = 'standard';
%     Param.MethodForEctopy = 'lomb';
%     Param.MethodForEctopy = 'differences';
    Param.MethodForEctopy = 'standard lomb differences';
%     Param.MethodForEctopy = 'standard differences';
    Param.Alignment = 'st';
    
    success = TWA;

    global QRSRelInd TimePoint
    QRSRelInd = 0;
    TimePoint = 1;
    
    BuildInterfaceSpectral(@ECGCallb, @SICallb, @AltSCallb);

    global recordbtn record
    set(recordbtn, 'String', record);

    if (success)
        DrawSuperimposed;
        DrawAltSeries;    
        DrawPSD;
        DrawAvgPSD;
        DrawText;
    end;
    DrawECG;
    
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ECGCallb

    global hecg;
    [hecg x] = UpdateCursor(hecg);

    global s 
    global beats 
    global StartQRSInd

    i = StartQRSInd;
    BeatIndex(x, s, beats);

    DrawSuperimposed;
    DrawAltSeries;

return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function SICallb

    global Align
    global TimePoint

    global hSI
    [hSI x] = UpdateCursor(hSI);

    if (x <= Align.q2f + Align.f2s || x > Align.q2f + Align.f2s + Align.st)
        TimePoint = 1;
    else
        TimePoint = x - (Align.q2f + Align.f2s);
    end;
    DrawAltSeries;
    DrawPSD;

return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function AltSCallb

    global hAltS;
    [hAltS x] = UpdateCursor(hAltS);
    
    global QRSRelInd beats;
    if (x >= 1 && x <= beats - 1)
        QRSRelInd = x - 1;
    else
        QRSRelInd = 0;
    end;
    DrawSuperimposed;
    DrawECG;

return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function BeatIndex(x, s, beats)

    global StartQRSInd QRSRelInd
    
    if (s(StartQRSInd) > x)
        QRSRelInd = 0;
    elseif (s(StartQRSInd + beats - 1) < x)
        QRSRelInd = beats - 1;
    else
        for j = StartQRSInd:StartQRSInd + beats - 1
            if (s(j) < x && s(j+1) > x)
                QRSRelInd = j - StartQRSInd;
            end;
        end;
    end;
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function res = mmedian(a)
res = floor(median(a(find(a))));
return;
