function DoTWAbyMMA(varargin)
% DoTWAbyMMA.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% This is the routine to run if you want analysis with MMA method on a
% single file

    close all;
    clear all;
    
    global Param
    Param.Metric = 'MMA';   % modified moving average
    Param.Alignment = 'st';

    TWA;

    global lead TWARes
    lead = TWARes.max_lead;
    
    global CurResIndex
    CurResIndex = TWARes.max_index;
    global CurQRS
    CurQRS = TWARes.res(CurResIndex).StartQRSInd;
    
    BuildInterfaceMMA(@ECGCallb, @TrendCallb);
    global recordbtn record
    set(recordbtn, 'String', record);
    
    DrawECG;    
    DrawAvg;
    DrawVAltTrend;
    DrawSelections;
    DrawText;
    
return;

function ECGCallb

    global hecg;
    [hecg x] = UpdateCursor(hecg);

    global CurResIndex freq TWARes Param
    CurResIndex = floor(x / (Param.Interval * freq)) + 1;
    if (CurResIndex < 1)
        CurResIndex = 1;
    elseif (CurResIndex > length(TWARes.res))
        CurResIndex = length(TWARes.res);
    end;

    
    global q CurQRS
    if q(TWARes.res(CurResIndex).StartQRSInd) > x
        CurResIndex = CurResIndex - 1;
        CurQRS = TWARes.res(CurResIndex).EndQRSInd;
    else
        for CurQRS = TWARes.res(CurResIndex).StartQRSInd : TWARes.res(CurResIndex).EndQRSInd
            if CurQRS >= length(q) || q(CurQRS + 1) > x
                break;
            end;
        end;
    end;
    
    DrawAvg;
    DrawVAltTrend;
    DrawSelections;

return;

function TrendCallb

    global hTrend;
    [hTrend x] = UpdateCursor(hTrend);

    global CurResIndex freq TWARes Param
    CurResIndex = x;
    
    if (CurResIndex < 1)
        CurResIndex = 1;
    elseif (CurResIndex > length(TWARes.res))
        CurResIndex = length(TWARes.res)
    end;
    CurQRS = TWARes.res(CurResIndex).StartQRSInd;

    DrawText;
    DrawECG;
    DrawAvg;
    DrawSelections;
    
return;
