function DrawAvgPSD
% DrawAvgPSD.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the Average Power Spectral Density (subplot 5)

    global lead QRSRelInd TimePoint graph TWARes Param Align

    subplot(graph(5)); cla

    if (isempty(TWARes) || ~Align.validleads(lead))
        return;
    end;

    global Param
    color = {'b', 'g', 'r'};
    leg = cellstr({});

    % Plot average PSD for lomb if present
    if ~isempty(strfind(Param.MethodForEctopy, 'lomb'))
        leg{length(leg) + 1} = 'lomb'; 

        subplot(graph(5)); 
        plot(TWARes.lomb.avg_psd(:, lead), color{length(leg)}); hold on
    end;
    
    % Plot average PSD for others if present
    names = cellstr({'standard', 'differences'});
    for i = 1:length(names)
        if ~isempty(strfind(Param.MethodForEctopy, names{i}))
            leg{length(leg) + 1} = names{i};

            subplot(graph(5)); 
            plot(TWARes.(names{i}).avg_psd(:, lead), color{length(leg)}); hold on
        end;
    end;

    % draw labels
    subplot(graph(5)); 
    legend(leg, 2);
    xlabel('frequency'); title('Ave. PSD'); hold off

return;