function DrawSuperimposed
% DrawSuperimposed.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the graph associated with the beat waveforms before and after the
% cursor in the ECG window
% The waveform is the portion of the beat from Q to the end of T wave.

    global graph Align lead
    global QRSRelInd

    ind = QRSRelInd + 1;

    subplot(graph(2));
    cla;

    
    if (isempty(Align.fid))
        return;
    end;

    SaveAxisLimits;
    
    DrawSingle(ind, 'b');
    hold on;
    DrawSingle(ind + 1, 'g');
    plot([Align.qs_templ(:, lead); Align.st_templ(:, lead)], 'r');
    legend(['beat ' num2str(ind)],['beat ' num2str(ind+1)], 'template')
    
    % points after this one are taken into account
    x = Align.q2f + Align.f2s;
    plot([x x], get(gca, 'YLim'), 'r');
    
    DrawTextCorr(ind);
    
    global hSI
    global TimePoint
    if (ishandle(hSI))
        delete(hSI);
    end;
    x = Align.q2f + Align.f2s + TimePoint;
    hSI = plot([x x], get(gca, 'YLim'), 'k');

    hold off;

    RestoreAxisLimits;
    
return;

function DrawTextCorr(ind)

global Align lead

for i = 1:2
    a(i) = floor(Align.QRScorr(ind + i - 1, lead) * 100) / 100;
    b(i) = floor(Align.Tcorr(ind + i - 1, lead) * 100) / 100;
end;
s = ['correlation with template:\newline' 'QRS: ' num2str(a(1)) ' and ' num2str(a(2)) ...
        '\newline' 'ST: ' num2str(b(1)) ' and ' num2str(b(2))];

text(0.4, 0.65, s, 'Units','normalized');

return;

function DrawSingle(ind, color)

global Align TWARes lead ecg Param

if (Align.valid(ind, lead) || isempty(strfind(Param.MethodForEctopy, 'standard')) && isempty(strfind(Param.MethodForEctopy, 'differences')) || ...
        ~isfield(TWARes.standard, 'avg_odd') || ~isfield(TWARes.standard, 'avg_even'))
    plot(ecg(Align.fid(ind) - Align.q2f : Align.fid(ind) + Align.f2s + Align.st, lead) - Align.amp(ind, lead), color); 
else
% if the beat was ectopic or too noisy plot the average waveform depending
% on whether the selected beat is even or odd
    if mod(ind, 2)
        v = TWARes.standard.avg_odd;
    else
        v = TWARes.standard.avg_even;
    end;

    plot(Align.q2f + Align.f2s + 1:Align.q2f + Align.f2s + Align.st, v(:, lead), 'm');
end;
title ('Waveform')
ylabel(['amplitude']);
return;

