%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function LeadBtnCallback
% LeadBtnCallback.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Switch displayed lead
    global lead ecg
    nleads = size(ecg, 2);
    lead = lead + 1;
    if (lead > nleads)
        lead = 1;
    end;
    set(gco, 'String', sprintf('lead is %d', lead));
    DrawECG; % subplot 1
    
    global Param
    if ~isempty(Param)
        if (strcmp(Param.Metric, 'SM'))
            DrawSuperimposed; % subplot 2
            DrawAltSeries; % subplots 3,4,5
            DrawPSD;
            DrawAvgPSD;
        else
            DrawAvg;
            DrawVAltTrend;
            DrawSelections;
        end;
        DrawText; % the title on subplot 1
    end;
return;
