function TWASpectralOnAFile
% TWASpectralOnAFile.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% performs the SM analysis for TWA on first 128 beats in the file and if unsuccessfult moves
% forward until finds any 128 beats where it succeeds

    clear global TWARes Align
    global ecg q s TWARes Align beats record stlen

    global StartQRSInd
    Align.fid = [];
    StartQRSInd = 0;
    %%%%%%%%%%% setting start indices for known files to avoid long
    %%%%%%%%%%% calculations
    if (strcmp(record, 'twa30'))
        StartQRSInd = 101;
    elseif(strcmp(record, 'twa74'))
        StartQRSInd = 21;
%     elseif (~isempty(strfind(record, 'ecgTWAwHRV')))
%         StartQRSInd = 440;
    end;
    %%%%%%%%%%%
    incr = 20;
    
    foundfid = false;
    
    %   repeat until we are successfull
    while ((StartQRSInd == 0 || StartQRSInd + incr + beats < min(length(q), length(s))))
        if (StartQRSInd == 0)
            StartQRSInd = 1;
        else
            StartQRSInd = StartQRSInd + incr;
            disp(['TWASpectralOnAFile: moving ' num2str(incr) ' beats forward, starting from beat ' num2str(StartQRSInd)]);
        end;

        disp('TWASpectralOnAFile: aligning beats...');
        Align = AlignBeats(ecg, beats, q(StartQRSInd:StartQRSInd + beats - 1), s(StartQRSInd:StartQRSInd + beats - 1), stlen);
        if (isempty(Align.fid))
            disp('TWASpectralOnAFile: failed');
            continue;
        else
            disp('TWASpectralOnAFile: succeeded');
            foundfid = true;            
        end;

        disp('TWASpectralOnAFile: looking for alternans...');
        [TWARes, Align] = TWASpectral(ecg, Align);
        
        if (IsSuccessfull(TWARes))
            disp('TWASpectralOnAFile: succeeded');
            break;
        end;
        disp('TWASpectralOnAFile: failed');
    end;
    
    if (isempty(TWARes) || ~IsSuccessfull(TWARes))
        disp('TWASpectralOnAFile: No significant alternans values found...');
    end;
    
%     if (~foundfid)
%         fFidFail = fopen('twa_res_fidFails.txt', 'a');
%         fprintf(fFidFail, '%s\n', record);
%         fclose(fFidFail);
%     end;
return;

function res = IsSuccessfull(TWARes)
res = (isfield(TWARes, 'lomb') && TWARes.lomb.successfull) || ...
            (isfield(TWARes, 'standard') && TWARes.standard.successfull) || ...
            (isfield(TWARes, 'differences') && TWARes.differences.successfull);
return;